/*
 *        mbTabset plug in
 * 				developed by Matteo Bicocchi on JQuery
 *        2002-2009 Open Lab srl, Matteo Bicocchi
 *			    www.open-lab.com - info@open-lab.com
 *       	version 1.9
 *       	tested on: 	Explorer, FireFox and Chrome for PC
 *                  	FireFox and Safari for Mac Os X
 *                  	FireFox for Linux
 *        @update author sunnyjiang
 *        @version 1.1
 */

(function($) {
	$.mbTabset = {
		mbTabsetArray:[],
		options:{
			container: "",
	    	item: "div",
	    	axis: "x",
	    	sortable: true,
	    	position: "left",
	    	start: function() {},
	    	stop: function() {}
		},

		build: function(opt) {
			this.each(function() {
				$(this).addClass("mbTabset");
				var mbTabsetOptions = {};
				$.extend (mbTabsetOptions, $.mbTabset.options);
	        
				var el = {el: $(this)};
				$.extend (mbTabsetOptions, el);
				$.extend (mbTabsetOptions, opt);
	        
				$(this).addClass(mbTabsetOptions.position);
	        
				var tabs = $(this).find(mbTabsetOptions.item);
	        
				this.opt = mbTabsetOptions;
				this.opt.tabs = tabs;
	        
				var hasSel = $(tabs).is(".sel");
	        
				if (!hasSel) 
					$(this).find(mbTabsetOptions.item + ":first").addClass("sel");
	        
				if ($.metadata) 
					$.metadata.setType("class");
	        
				$(tabs).each(function() {
					$(this).setAsMbTab(mbTabsetOptions);
				});
	        
				if (mbTabsetOptions.sortable){
					$(this).setSortableMbTabset(mbTabsetOptions);
				}
			});
		},
	
		setAsTab: function(opt) {
			if ($.metadata){
				$.metadata.setType("class");
					if ($(this).metadata().content) 
						$(this).attr("content", $(this).metadata().content);
			}

			$(this).bind("mousedown", function(event) { // 鼠标按下就激活		
				// 中键关闭tab
				if(event.button == 1) {
					tabManager.removeTab(this);
					browser.extension.builtin.statistics.increase(STATIS_CMD_CLOSE_TAB_BY_MOUSE_MIDDLE_BTN);//鼠标中键关闭标签页的次数上报
				}
				
				if(event && event.button == 2) { // 点击右键或者中键时不处理
					return;
				}

				// get current tab
				var tab = $(this);
			
				if(tab.is('.tab-close')) { // close button return
					return;
				}
			
				// get tab
				while(!tab.is('.tab')) {
					tab = tab.parent();
				}
			
				// current tab not deal
				if (tab.is(".disabled , .sel")) 
					return;
				
				// 显示逻辑
				var tabWidth = tab.width();
				
				var currentTabTitle = $('.title', tab);
				var currentTabIcon = $('img', tab);
				var currentTabCloseButton = $('.tab-close', tab);
				
				// 标签内元素显示与否的逻辑
				if(tabWidth <= 52 && tabWidth > 40) {
					currentTabTitle.hide();
					currentTabIcon.show();
					currentTabCloseButton.show();	
				} else if(tabWidth <= 40) {
					currentTabTitle.hide();
					currentTabIcon.hide();	
					currentTabCloseButton.show();
				} else {
					currentTabTitle.show();
					currentTabIcon.show();	
					currentTabCloseButton.show();					
				}	
				
				// 标签内元素显示位置的逻辑
				if(tabWidth <= 17) {
					currentTabCloseButton.css('margin-right', '-6px');			
				} else if(tabWidth <= 19) {
					currentTabCloseButton.css('margin-right', '-5px');			
				} else if(tabWidth <= 24) {
					currentTabCloseButton.css('margin-right', '-4px');										
				} else if(tabWidth <= 28) {
					currentTabCloseButton.css('margin-right', '-2px');				
				} else {
					currentTabCloseButton.css('margin-right', '0px');				
				}

				if(tab.is('.new')) {
					$('img', tab).css('margin-left', '4px');
					tab.removeClass("new");
				}
				
				// remove last selected tab style
				var lastTab = $('#tabset .sel');
				lastTab.removeClass("sel").removeClass('tab-hover').removeClass("new").css('z-index', 10); // 去掉选中使选定的tab始终在前
				
				if(tabWidth <= 52 && tabWidth > 40) {
					$('.title', lastTab).show();
					$('img', lastTab).show();
					$('.tab-close', lastTab).hide();	
				} else if(tabWidth <= 40 && tabWidth > 21) {
					$('.title', lastTab).hide();
					$('img', lastTab).show();	
					$('.tab-close', lastTab).hide();
				} else if(tabWidth <= 21) {
					$('.title', lastTab).hide();
					$('img', lastTab).hide();	
					$('.tab-close', lastTab).hide();							
				} else {
					$('.title', lastTab).show();
					$('img', lastTab).show();	
					$('.tab-close', lastTab).show();					
				}						
				
				tab.addClass("sel").css('z-index', 20); // 设定选中，使选定的tab始终在前
	
				// set url of address bar when click tab
				addressbar.setAddress(tabManager.getUrl(tab));
								
				// call browser function
				var tabId = tab.attr('id');
				var pageId = tabManager.getPageIdFromTab(tab); 
				if(!tab.data('switch')) {
			        //little
					// 显示密码保存infobar的逻辑
					//qqbrowser.log.info("littleli: 点击逻辑" + "pageId:" + pageId);
					//qqbrowser.log.info("littleli:" + tabInfo[pageId - 1]);
					if ( tabInfo[pageId - 1] !== undefined) {
						//savePWinfobar.userText = tabInfo[pageId - 1][0];				
						//savePWinfobar.webpageText = tabInfo[pageId - 1][1];
						//savePWinfobar.finalText =  "您需要 QQ浏览器 帮您保存此网站的密码吗？";
						//savePWinfobar.setText(savePWinfobar.finalText);
						savePWinfobar.showClose(true);
						window.savePWinfobar.rememberButton.show(true);
						window.currentPageId = pageId;
						window.savePWinfobar.show(true);
					}
					else
					{
						window.currentPageId = -1;
						window.savePWinfobar.show(false);
					}
					
					
					if (tab.attr("state") === "1") {	//崩溃
						//infobar.setText(infobar.crashText);
						//infobar.showClose(false);
						//infobar.show(true);
						qqbrowser.page.reload(browser.getCurrentPageId());	//直接刷新
					} else if (tab.attr("state") === "2") {	//假死
						infobar.setText(infobar.zombieText);
						infobar.showClose(true);
						window.infobar.refreshButton.show(true);
						window.infobar.show(true);
					} else {
						infobar.show(false);
					}
					browser.tabs.select(tabId);
				} else {
					// 显示密码保存infobar的逻辑
					//qqbrowser.log.info("littleli: 切换逻辑" + "pageId:" + pageId);
					//qqbrowser.log.info("littleli:" + tabInfo[pageId - 1]);
					if ( tabInfo[pageId - 1] !== undefined) {
						//savePWinfobar.userText = tabInfo[pageId - 1][0];				
						//savePWinfobar.webpageText = tabInfo[pageId - 1][1];
						//savePWinfobar.finalText = "您需要 QQ浏览器 帮您保存此网站的密码吗？";
						//savePWinfobar.setText(savePWinfobar.finalText);
						savePWinfobar.showClose(true);
						window.savePWinfobar.rememberButton.show(true);
						window.currentPageId = pageId;
						window.savePWinfobar.show(true);
					}
					else
					{
						window.currentPageId = -1;
						window.savePWinfobar.show(false);
					}
					
					if (tab.attr("state") === "1") {	//崩溃
						//infobar.setText(infobar.crashText);
						//infobar.showClose(false);
						//infobar.show(true);
						qqbrowser.page.reload(browser.getCurrentPageId());	//直接刷新
					} else if (tab.attr("state") === "2") {	//假死
						infobar.setText(infobar.zombieText);
						infobar.showClose(true);
						window.infobar.refreshButton.show(true);
						window.infobar.show(true);
					} else {
						infobar.show(false);
					}
					//qqbrowser.log.info("littleli: 切换逻辑完成");
					browser.skin.window.setFocus();
				}
				

				
				//browser.extension.builtin.statistics.increase(STATIS_CMD_SWITCH_TAB_BY_MOUSE_CLICK); //鼠标点击切换标签页的次数上报

				view.setBackAndForwardButtonStatus(); // 根据状态切换back和forward按钮的显示
				
				// set address bar engine image
				view.setEngine();
				
				view.showPageStatus(tabId);

//				event.stopPropagation();
//				return false;
			});
		
			// 延迟处理焦点切换
			$(this).bind("mouseup", function() {
				view.setFocus(tabManager.getUrl($(this)), this);
			});	
				      
			$(this).bind("dblclick", function() { 
				tabManager.removeTab(this);
				browser.extension.builtin.statistics.increase(STATIS_CMD_CLOSE_TAB_BY_DBCLICK);	//双击关闭标签次数上报	
				return false;
			});
		},
    
		addTab: function(url, title, icon, engine, index) {
			var opt = $(this)[0].opt;
			if(opt) {
				if($(this).find(opt.item).length == MAX_TAB_COUNT) {
					return;
				} 
			}

			var tabOpt = {
	    		// fixed 不能根据length来，可能有过删除，应该取中间最大的一个
	    		id: "tab_" + (tabManager.getMaxTabIndex() + 1),
	    		title: title
	    	};

	    	this.buildTab($(this), tabOpt.id, url, title, icon, engine, index); 
	      
	    	var tab = $(this).find("#" + tabOpt.id);
	
	    	opt.tabs = $(this).find(opt.item);
	    	tab.setAsMbTab(opt);
	    	
	    	if (opt.sortable)
	    		$(this).setSortableMbTabset(opt);
	    	
	    	return tabOpt.id;
		},		

	    buildTab: function(root, id, url, title, icon, engine, index) {
			var defaultIcon = TAB_DEFAULT_ICON;
	    	url = url || DEFAULT_SITE_URL;
	    	title = title || url;
	    	icon = icon || defaultIcon;
	    	if(!engine)
	    		engine = '';

			var tabHTML = 
					"<div class='tab mbTab' id='" + id + "' engine='" + engine + "'>" +
						"<span>" + 
							"<img class='loading-animate' src='" + TAB_LOADING_ICON + "' />" + 
							"<div class='title'>" + title + '</div>' + 
							'<div class="tab-close"></div>' +
						"</span>" +
					"</div>";
			
			if(!index || tabManager.getCount() == 0) { // 没有index或者没有tab时在最后插入
				root.append(tabHTML);
			} else { // 在指定位置插入

				var insertAfterTab = tabManager.getFirstTab();

				for(var i = 1; i < index; i++) {
					insertAfterTab = insertAfterTab.next();
				}

				$(tabHTML).insertAfter(insertAfterTab);
			}
			
//			$('#' + id).animate({ width: 100 }, 1000);
			
			$('#' + id).bind('mouseover', function() {
				tipManager.showTabTip($(this), event);
			}).data('url', url);

	        // icon加载失败的动作
	        $('#' + id + ' img').bind('error', function() {
	        	this.src = defaultIcon;
	        });	        
	        
	        // 点击关闭标签按钮的动作
	        $('#' + id + ' .tab-close').bind('mouseover', function() {
				tipManager.showCloseTabTip($(this));
				return false;
			}).bind('mousedown', function() {
	        	view.setCloseButtonPressed(this);
	        	return false;
	        }).bind('click', function() {
	        	tabManager.removeTab(this);
				browser.extension.builtin.statistics.increase(STATIS_CMD_TAB_BTN_CLOSE_CLICKED);	//关闭标签按钮（叉叉）点击次数上报				
	        	return false;
	        }).append('<span class="hover"></span>').hover(function() {
                view.fadeButtonIn.apply(this);
        	}, function() {
        		var el = this;
            
        		setTimeout(function() {
        			if (!el.open) view.fadeButtonOut.apply(el);
        		}, 10);
            }); 
	    },

	    toArray: function(el) {
	    	return $(el).sortable("toArray");
	    },
	    
	    select: function() {
	    },
	    
	    setSortable: function(opt) {
	    	if (!opt) opt = $(this)[0].opt;
	    	var tabs = $(this).find(opt.item).not(".block");
	      
	    	$(tabs).each(function() {
	    		if($(this).find("i").size() == 0) {
	//          $(this).find("span").prepend("<i>&nbsp;</i>").addClass("sortable");
	//    			$(this).addClass("sortable");
	    			$(this).bind("click", function(e) { 
	    				e.preventDefault();
	    				return false;
	    			});
	    		};
	    	});
	      
	    	$(this).sortable({
	    		item: opt.item,
//	    		delay: 300,
	    		distance: 8, // Distance in pixels after mousedown the mouse must move before dragging should start. This option can be used to prevent unwanted drags when clicking on an element.
	    		handle: this,
	    		cursor: "move",
	    		cancel: '.tab-close', // tab-close div不允许拖动
	    		//revert: '150', // 平滑移动到位置, tab hack的问题，暂时去掉
	    		axis: opt.axis, // 移动方向，可横向移动
	    		tolerance: 'pointer', // 什么时候触发排序, 'intersect'
//	    		opacity: .7,
	    		forcePlaceholderSize: false,
	    		scroll: false, // 不能滚动
	    		containment: '#tab-wrapper', // 设置可拖动范围为tab-wrapper
	    		start: function() {
	    			// TODO why ui have not properties?
	    			var currentTab = tabManager.getCurrentTab();
	    		
	    			$(this).find(".tab").addClass("floatEl");
	    			if (opt.start) 
	    				opt.start();
	    			// 设置拖动占位符的宽度
	    			$('#tabset .ui-sortable-placeholder').width(currentTab.width());   
	    			
	    			var dragY = event.pageY;
	    			var dragX = event.pageX;  
	    			
	    			// 标签拖出的逻辑
/*	    			$(window).bind('mousemove', function() {
	    				if(Math.abs(event.pageY - dragY) > 3 && Math.abs(dragX - event.pageX) < 1) { // 判断是否是垂直拖拽
//	    					browser.skin.tab.triggerDragOut(tabId);
//	    					debug(event.pageY);
	    						    					
	    					var tabIndex = tabManager.getPageIdFromTab(currentTab);

	    					// 拖出后删除tab
	    					tabManager.removeTab(currentTab, 1);
	    					
	    					browser.skin.tab.triggerDragOut(tabIndex);
	    				}
	    			});*/
	    		},
	    		sort: function() {
//	    			$(window).unbind('mousemove'); // remove mouseove event	
	    		},
	    		stop: function() {
	    			$(this).find(".tab").removeClass("floatEl");

//					alert(tabManager.getCurrentTab().attr('id'));
					var currentTab = tabManager.getCurrentTab();
					var pageId = tabManager.getPageIdFromTab(currentTab);
					var index = $('#tabset .tab').index(currentTab);
					
					browser.tabs.drag(pageId, index);
					browser.extension.builtin.statistics.increase(STATIS_CMD_SWITCH_TAB_BY_DRAG);	//drag切换标签页的次数上报
//	    			$(window).unbind('mousemove'); // remove mouseove event
//	    			$(window).unbind('mousemove');
//	    			$.mbTabset.mbTabsetArray = $.mbTabset.toArray($(this));
//	    			if (opt.stop) 
//	    				opt.stop();
	    		}
	    	});
		},
		
		selectMbTab: function() {
			$(this).click();
		}
	};

	$.fn.setAsMbTab = $.mbTabset.setAsTab;
	$.fn.addMbTab = $.mbTabset.addTab;
	$.fn.buildTab = $.mbTabset.buildTab; 
	$.fn.setSortableMbTabset = $.mbTabset.setSortable;
	$.fn.buildMbTabset = $.mbTabset.build;
	$.fn.serializeMbTabset = $.mbTabset.serialize;
	$.fn.selectMbTab = $.mbTabset.selectMbTab;
})(jQuery);